-- 协议常量
_UART1_HEAD_ = 0x5A
_UART1_TAIL_HIGH_ = 0xFC
_UART1_TAIL_LOW_  = 0xFF

-- 功能码定义
g_func = {
    onoff = 0x0001,
    light = 0x0002,
    name  = 0x0003
}

-- 串口通信对象
uart1 = {
    cmd = {
        buff = {},
        index = 0,
        state = "IDLE",
        total_len = 0
    }
}

-- 发送协议帧
function uart1.dataSend(ch, fcode, data)
    local send_buff = {}

    send_buff[1] = 0xA9
    send_buff[2] = 0x00  -- 长度高字节（暂定）
    send_buff[3] = 0x00  -- 长度低字节（暂定）

    send_buff[4] = (fcode >> 8) & 0xFF
    send_buff[5] = fcode & 0xFF

    if fcode >= 0x0001 and fcode <= 0x0002
    then
        send_buff[6] = (data >> 8) & 0xFF
        send_buff[7] = data & 0xFF

    elseif fcode == 0x0003
    then
        for i = 1, string.len(data)
        do
            send_buff[#send_buff + 1] = string.byte(data, i)
        end
    end

    send_buff[#send_buff + 1] = 0xFC
    send_buff[#send_buff + 1] = 0xFF

    local datalen = #send_buff - 3
    send_buff[2] = (datalen >> 8) & 0xFF
    send_buff[3] = datalen & 0xFF

    uart_send(ch, send_buff)
end

-- 协议解析
function __ProtocolParse(buff)

    local fcode = (buff[3] << 8) | buff[4]

    local switch = {
        [g_func.onoff] = function()
            local val = buff[5]
            set_uint16(VT_LW, 0x1001, val)
        end,

        [g_func.light] = function()
            local val = buff[5]
            set_uint16(VT_LW, 0x1000, val)
        end,

        [g_func.name] = function()
            local name = ''
            for i = 5, #buff - 2
            do
                name = name .. string.char(buff[i])
            end
            set_string(VT_LW, 0x1010, name)
        end
    }

    local handler = switch[fcode]
    if handler
    then
        handler()
    end
end

-- 串口接收处理
function uart1.ComRecv(ch, packet)
    for i = 1, #packet
    do
        local byte = packet[i]
        local cmd = uart1.cmd
        print('cmd.state  : '..(cmd.state ))

        print(cmd.index..'/'..cmd.total_len..' / '..(string.format('%02X', byte)))
        if cmd.state == "IDLE"
        then
            if byte == _UART1_HEAD_
            then
                cmd.buff = { byte }
                cmd.index = 1
                cmd.state = "LENGTH"
            end

        elseif cmd.state == "LENGTH"
        then
            table.insert(cmd.buff, byte)
            cmd.index = cmd.index + 1

            local L = byte
            if L < 4 or L > 250
            then
                cmd.state = "IDLE"
            else
                cmd.total_len = 1 + 1 + L
                if cmd.total_len <= 2
                then
                    cmd.state = "IDLE"
                else
                    cmd.state = "DATA"
                end
            end

        elseif cmd.state == "DATA"
        then
            table.insert(cmd.buff, byte)
            cmd.index = cmd.index + 1
            
            if cmd.index == cmd.total_len
            then
                
                local len = #cmd.buff
                print(cmd.index..'/'..cmd.total_len..' / '..(string.format('%02X', cmd.buff[len - 1]))..' / '..(string.format('%02X', cmd.buff[len])))
                if len >= 3
                   and cmd.buff[len - 1] == _UART1_TAIL_HIGH_
                   and cmd.buff[len]     == _UART1_TAIL_LOW_
                then
                    __ProtocolParse(cmd.buff)
                end
                cmd.state = "IDLE"
            end
        end
    end
end